function [puncta_coordinates,all_coordinates] = storm_puncta_analysis_per_image(filename, output_folder)

[~,fname,~] = fileparts(filename);
puncta_output = [output_folder filesep fname '_individual_puncta_images'];
I = imread(filename);
imf = imfinfo(filename);

if imf.XResolution == imf.YResolution
    um_per_px = 1/imf.XResolution;
else
    um_per_px = 1;
    warning('No Resolution information present, all output in units of pixels');
end

I_bin = imbinarize(I);
%[y,x] = ind2sub(size(I_bin),find(I_bin));
%X = [x,y];
%idx = dbscan(X,17,3);
%figure; imshow(I_bin); hold on;
%gscatter(X(:,1),X(:,2),idx);


I_close = imclose(I_bin,strel('disk',17,0));
L = bwlabel(I_close,8);
I_puncta = uint16(I_bin>0).*uint16(L);


num_puncta = max(max(I_puncta));
I_puncta_final = zeros(size(I_puncta),'uint16');
I_left_out_final = zeros(size(I_puncta),'uint16');
info = [];
puncta_coordinates = table();
left_out_coordinates = table();
all_coordinates = table();
%info = zeros(num_puncta,2,'double');

mkdir(puncta_output);
close all;



for i = 1:num_puncta
    %disp(i)
    curr_cluster = I_puncta == i;
    num_molecules = sum(sum(uint16(curr_cluster).*uint16(I)));
    num_white_px = sum(sum(uint16(curr_cluster)));
    if num_molecules > 10
        I_puncta_final(curr_cluster) = i;
        
        [y,x] = ind2sub(size(curr_cluster),find(curr_cluster));
        [ch,area] = convhull(x,y);
        cluster_alone = curr_cluster(min(y)-10:max(y)+10,min(x)-10:max(x)+10);
        
        figure; imshowpair(cluster_alone,I_bin(min(y)-10:max(y)+10,min(x)-10:max(x)+10))
        hold on;
        [y_new,x_new] = ind2sub(size(cluster_alone),find(cluster_alone));
        [ch_new,area_new] = convhull(x_new,y_new);
        if area ~= area_new
            error(['Something is wrong with area calculation with cluster ' i])
        end
        plot(x_new(ch_new),y_new(ch_new))
        im = getframe(gcf);
        imwrite(im.cdata,[puncta_output filesep fname '_puncta_' num2str(i) '.tif'],'Compression','None','Resolution',1200)
        close all;
        
        density = double(num_molecules)/double(area*um_per_px*um_per_px);
        info = [info; double(i) num_molecules area density];
        
        list_of_index_mult = cell2mat(rowfun(@(x) repmat(x,I(x),1),table(find(curr_cluster)),'OutputFormat','cell'));
        [y_puncta,x_puncta] = ind2sub(size(curr_cluster),list_of_index_mult); 
        t = table(y_puncta,x_puncta,repmat(i,size(x_puncta)),'VariableNames',{'X','Y','Cluster_ID'});
        puncta_coordinates = [puncta_coordinates; t];
        all_coordinates = [all_coordinates; t];
    else
       I_left_out_final(curr_cluster) = i;
       list_of_index_mult = cell2mat(rowfun(@(x) repmat(x,I(x),1),table(find(curr_cluster)),'OutputFormat','cell'));
       [y_puncta,x_puncta] = ind2sub(size(curr_cluster),list_of_index_mult); 
       t = table(y_puncta,x_puncta,repmat(i,size(x_puncta)),'VariableNames',{'X','Y','Cluster_ID'});
       left_out_coordinates = [left_out_coordinates; t];
       all_coordinates = [all_coordinates; t];
    end
end
tbl = table(info(:,1),info(:,2),info(:,3),info(:,4),'VariableNames',{'Puncta_ID' 'Number_molecules' 'Area' 'Density'});
imwrite(I_puncta_final,[output_folder filesep fname '_puncta_labeled_by_id.tif'])
imwrite(I_left_out_final,[output_folder filesep fname '_left_out_pixels_labeled_by_id.tif'])
writetable(puncta_coordinates, [output_folder filesep fname '_individual_puncta_coordinates.xlsx']);
writetable(left_out_coordinates, [output_folder filesep fname '_left_out_coordinates.xlsx']);
writetable(all_coordinates, [output_folder filesep fname '_all_coordinates.xlsx']);
writetable(tbl,[output_folder filesep fname '_puncta_analysis.xlsx']);
end